/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.client.renderer.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;

public class CustomCarriedBlockLayer<T extends Entity>
extends GeoLayerRenderer<T> {
    private final BlockRenderDispatcher blockRenderer;
    private final Supplier<EnderMan> enderman;

    public CustomCarriedBlockLayer(IGeoRenderer<T> entityRendererIn, BlockRenderDispatcher blockRenderDispatcher, Supplier<EnderMan> enderman) {
        super(entityRendererIn);
        this.blockRenderer = blockRenderDispatcher;
        this.enderman = enderman;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T animatable, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        BlockState state = this.enderman.get().m_32530_();
        if (state == null) {
            return;
        }
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            float lerped = Mth.m_14189_((float)partialTick, (float)this.enderman.get().f_20884_, (float)this.enderman.get().f_20883_);
            pose.mulPose(Vector3f.f_122225_.m_122240_(lerped));
            pose.translate(0.0, (double)this.enderman.get().m_6095_().m_20680_().f_20378_ - 2.9, 0.0);
            GeoBone leftArm = this.getEntityModel().getModel(this.getEntityModel().getModelResource(animatable)).getBone("left_arm").orElse(null);
            if (leftArm == null) {
                return;
            }
            poseStack.m_166854_(leftArm.getLocalSpaceXform());
            pose.translate(0.32, -2.35, 0.0);
            EnderMan enderMan = this.enderman.get();
            if (enderMan instanceof BaseEnderman) {
                BaseEnderman base = (BaseEnderman)enderMan;
                Vec3 offset = base.getHeldBlockOffset();
                pose.translate(offset.f_82479_, offset.f_82480_, offset.f_82481_);
            }
            pose.translate(0.0, 0.6875, -0.75);
            pose.mulPose(Vector3f.f_122223_.m_122240_(20.0f));
            pose.mulPose(Vector3f.f_122225_.m_122240_(45.0f));
            pose.translate(-1.35, 0.4, 1.35);
            pose.scale(0.5f, 0.5f, 0.5f);
            pose.mulPose(Vector3f.f_122225_.m_122240_(90.0f));
            this.blockRenderer.m_110912_(state, poseStack, bufferSource, packedLight, OverlayTexture.f_118083_);
        }
    }
}

